/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorKey;
import com.misterpemodder.shulkerboxtooltip.api.color.ColorRegistry;
import com.misterpemodder.shulkerboxtooltip.impl.PluginManager;
import com.misterpemodder.shulkerboxtooltip.impl.color.ColorRegistryImpl;
import com.misterpemodder.shulkerboxtooltip.impl.config.Configuration;
import com.misterpemodder.shulkerboxtooltip.impl.config.JsonHexadecimalInt;
import com.misterpemodder.shulkerboxtooltip.impl.util.Key;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonElement;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonObject;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.JsonPrimitive;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.DeserializationException;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.Marshaller;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.SyntaxError;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public class ShulkerBoxTooltipConfigSerializer
implements ConfigSerializer<Configuration> {
    private final Config definition;
    private final Jankson jankson;

    public ShulkerBoxTooltipConfigSerializer(Config definition, Class<?> configClass) {
        this(definition, configClass, ShulkerBoxTooltipConfigSerializer.buildJankson());
    }

    protected ShulkerBoxTooltipConfigSerializer(Config definition, Class<?> configClass, Jankson jankson) {
        this.definition = definition;
        this.jankson = jankson;
    }

    private static Jankson buildJankson() {
        Jankson.Builder builder = Jankson.builder();
        builder.registerDeserializer(JsonObject.class, Configuration.class, ShulkerBoxTooltipConfigSerializer::fromJson);
        builder.registerSerializer(Configuration.class, ShulkerBoxTooltipConfigSerializer::toJson);
        if (ShulkerBoxTooltip.isClient()) {
            ClientOnly.buildJankson(builder);
        }
        return builder.build();
    }

    private static Configuration fromJson(JsonObject obj, Marshaller marshaller) {
        Configuration cfg = new Configuration();
        Configuration.PreviewCategory previewCategory = (Configuration.PreviewCategory)marshaller.marshall(Configuration.PreviewCategory.class, (JsonElement)obj.getObject("preview"));
        Configuration.TooltipCategory tooltipCategory = (Configuration.TooltipCategory)marshaller.marshall(Configuration.TooltipCategory.class, (JsonElement)obj.getObject("tooltip"));
        Configuration.ServerCategory serverCategory = (Configuration.ServerCategory)marshaller.marshall(Configuration.ServerCategory.class, (JsonElement)obj.getObject("server"));
        if (previewCategory != null) {
            cfg.preview = previewCategory;
        }
        if (tooltipCategory != null) {
            cfg.tooltip = tooltipCategory;
        }
        if (serverCategory != null) {
            cfg.server = serverCategory;
        }
        if (ShulkerBoxTooltip.isClient()) {
            Configuration.ColorsCategory colorsCategory = (Configuration.ColorsCategory)marshaller.marshall(Configuration.ColorsCategory.class, (JsonElement)obj.getObject("colors"));
            Configuration.ControlsCategory controlsCategory = (Configuration.ControlsCategory)marshaller.marshall(Configuration.ControlsCategory.class, (JsonElement)obj.getObject("controls"));
            if (colorsCategory != null) {
                cfg.colors = colorsCategory;
            }
            if (controlsCategory != null) {
                cfg.controls = controlsCategory;
            }
        }
        return cfg;
    }

    private static JsonObject toJson(Configuration cfg, Marshaller marshaller) {
        JsonObject obj = new JsonObject();
        obj.put("preview", marshaller.serialize((Object)cfg.preview));
        obj.put("tooltip", marshaller.serialize((Object)cfg.tooltip));
        if (ShulkerBoxTooltip.isClient()) {
            obj.put("colors", marshaller.serialize((Object)cfg.colors));
            obj.put("controls", marshaller.serialize((Object)cfg.controls));
        }
        obj.put("server", marshaller.serialize((Object)cfg.server));
        return obj;
    }

    public void serialize(Configuration config) throws ConfigSerializer.SerializationException {
        Path configPath = this.getConfigPath();
        ShulkerBoxTooltip.LOGGER.debug("Saving configuration to " + configPath);
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ShulkerBoxTooltip.isClient() && !PluginManager.areColorsLoaded()) {
            ShulkerBoxTooltip.LOGGER.debug("Configuration is not fully loaded, not saving");
            return;
        }
        try {
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            writer.write(this.jankson.toJson((Object)config).toJson(true, true));
            writer.close();
            ShulkerBoxTooltip.LOGGER.debug("Configuration saved successfully");
        }
        catch (IOException e) {
            throw new ConfigSerializer.SerializationException((Throwable)e);
        }
    }

    private Path getLegacyConfigPath() {
        return ShulkerBoxTooltip.getConfigDir().resolve(this.definition.name() + ".json");
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="4.0.0")
    private Configuration deserializeLegacy() {
        Path legacyConfigPath = this.getLegacyConfigPath();
        if (Files.exists(legacyConfigPath, new LinkOption[0])) {
            ShulkerBoxTooltip.LOGGER.info("Found legacy configuration file, attempting to load...");
            try {
                File file = legacyConfigPath.toFile();
                Configuration config = (Configuration)this.jankson.fromJson(this.jankson.load(file), Configuration.class);
                file.delete();
                ShulkerBoxTooltip.LOGGER.info("Loaded legacy configuration file!");
                return config;
            }
            catch (IOException | SyntaxError e) {
                ShulkerBoxTooltip.LOGGER.error("Could not load legacy configuration file", (Exception)e);
            }
        }
        return null;
    }

    private Path getConfigPath() {
        return ShulkerBoxTooltip.getConfigDir().resolve(this.definition.name() + ".json5");
    }

    public Configuration deserialize() throws ConfigSerializer.SerializationException {
        Configuration config = this.deserializeLegacy();
        if (config != null) {
            return config;
        }
        Path configPath = this.getConfigPath();
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                JsonObject obj = this.jankson.load(configPath.toFile());
                return (Configuration)this.jankson.fromJsonCarefully(obj, Configuration.class);
            }
            catch (IOException | DeserializationException | SyntaxError e) {
                throw new ConfigSerializer.SerializationException(e);
            }
        }
        ShulkerBoxTooltip.LOGGER.info("Could not find configuration file, creating default file");
        return this.createDefault();
    }

    public Configuration createDefault() {
        return new Configuration();
    }

    @Environment(value=EnvType.CLIENT)
    private static final class ClientOnly {
        private ClientOnly() {
        }

        private static void buildJankson(Jankson.Builder builder) {
            builder.registerDeserializer(String.class, Key.class, (str, marshaller) -> Key.fromTranslationKey(str));
            builder.registerDeserializer(JsonObject.class, Key.class, (obj, marshaller) -> Key.fromTranslationKey((String)obj.get(String.class, "code")));
            builder.registerSerializer(Key.class, (key, marshaller) -> {
                JsonObject object = new JsonObject();
                object.put("code", (JsonElement)new JsonPrimitive((Object)key.get().method_1441()));
                return object;
            });
            builder.registerDeserializer(JsonObject.class, ColorRegistry.class, ClientOnly::deserializeColorRegistry);
            builder.registerSerializer(ColorRegistry.class, ClientOnly::serializeColorRegistry);
        }

        private static ColorRegistry deserializeColorRegistry(JsonObject obj, Marshaller marshaller) {
            for (Map.Entry categoryEntry : obj.entrySet()) {
                Object v;
                class_2960 categoryId = class_2960.method_12829((String)((String)categoryEntry.getKey()));
                if (categoryId == null || !((v = categoryEntry.getValue()) instanceof JsonObject)) continue;
                JsonObject categoryObject = (JsonObject)v;
                ClientOnly.deserializeColorCategory(categoryId, categoryObject);
            }
            return ColorRegistryImpl.INSTANCE;
        }

        private static JsonObject serializeColorRegistry(ColorRegistry registry, Marshaller marshaller) {
            JsonObject object = new JsonObject();
            for (Map.Entry<class_2960, ColorRegistry.Category> categoryEntry : registry.categories().entrySet()) {
                JsonObject categoryObject = new JsonObject();
                for (Map.Entry<String, ColorKey> keyEntry : categoryEntry.getValue().keys().entrySet()) {
                    categoryObject.put(keyEntry.getKey(), (JsonElement)new JsonHexadecimalInt(keyEntry.getValue().rgb()));
                    categoryObject.setComment(keyEntry.getKey(), String.format("(default value: %#x)", keyEntry.getValue().defaultRgb()));
                }
                object.put(categoryEntry.getKey().toString(), (JsonElement)categoryObject);
            }
            return object;
        }

        private static void deserializeColorCategory(class_2960 id, JsonObject object) {
            ColorRegistryImpl.Category category = ColorRegistryImpl.INSTANCE.category(id);
            for (Map.Entry entry : object.entrySet()) {
                boolean isValidValue;
                Object v = entry.getValue();
                if (!(v instanceof JsonPrimitive)) continue;
                JsonPrimitive value = (JsonPrimitive)v;
                ColorKey key = category.key((String)entry.getKey());
                long rgbValue = value.asLong(Long.MIN_VALUE);
                boolean bl = isValidValue = rgbValue >= Integer.MIN_VALUE && rgbValue <= Integer.MAX_VALUE;
                if (key != null) {
                    if (isValidValue) {
                        key.setRgb((int)rgbValue);
                        continue;
                    }
                    key.setRgb(key.defaultRgb());
                    continue;
                }
                if (!isValidValue) continue;
                category.setRgbKeyLater((String)entry.getKey(), (int)rgbValue);
            }
        }
    }
}

